//******************************************
// file			: main.c
// version		: V1.2 2021/03/25
// brief		: main program
// note			: Toggle P90 to show CPU is working.
// 			      while P47 input Low level signal, CPU will be into STOP mode,
// 				  P90 stop toggle untill KWI6(P46) wake up CPU.
//****************************************** 
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6811.h"
#include "6801_REG_bit_V6.h"


//P40 connects to LED. when waking up, this pin is inverted once
//P46 key low active.  KWI6 pin is a wake-up function pin, wake-up once when it is grounded




uchar	flag1;



delay()
{
	
	uint	temp1;
	
	for(temp1=0;temp1<30000;temp1++)
	{
		WDCDR.byte = 0x4e;		//clear wdt
		
		}
}


void main()
{	
	WDCDR.byte = 0x4e;		//clear wdt
	flag1=0;

	P1CR.byte=0xff;
	P4CR.byte=0xff;
	P7CR.byte=0xff;
	P8CR.byte=0xff;
	P9CR.byte=0xff;


	P1DR.byte=0xff;
	P4DR.byte=0xff;
	P7DR.byte=0xff;
	P8DR.byte=0xff;
	P9DR.byte=0xff;		// please set all pins to output low to avoid 100uA leakage in STOP mode
	
	POFFCR0.byte=0;
	POFFCR1.byte=0;
	POFFCR2.byte=0;
	POFFCR3.byte=0;
	
	vd1en=0;			// there is 30uA leakage current if LVD function is not disable
	vd2en=0;

   	p4cr0=out_mode;
    
    	p4cr6=in_mode;
	
	P4PU.bit.b6	=	1;		//set P46(KWI6) input pull high


//	KWUCR0.bit.b5	=	0;	// set KWI2 STOP mode release level to low
//	KWUCR0.bit.b4	=	1;	// enable KWI2

	kw6en=1;
	kw6le=0;




	while(1)
	{
		WDCDR.byte = 0x4e;		//clear wdt
		flag1^=0xff;
		
		if(flag1==0){p40=0;}
			else{p40=1;}
				
				
		relm=1;
		
		outen=1;
		
		stop=1;
		
		
		while(p4prd6==0){WDCDR.byte = 0x4e;};
	
		delay();
	}         
             
       
    
}